%% MPC parameter

%% Time step
% MPC control time step
Ts_MPC = 1.0;

%% Scale 
% Scale factors
T_batt_scale = 10; % span of battery temperature in °C (1)
current_scale = 100; % span of battery current in A (200)
T_env_scale = 10; % span of enviroment temperature in °C (21)

%% Objective function
% Objective function weights
WeightTbattery = 1;
WeightSOC = 0;
WeightEPowerComp = 0.1;
WeightEPowerRateComp = 0.5;
WeightECR = 100000;

%% Prediction and control horizons
% Prediction horizon
p = 9;
% Control horizon
pc = 4;

%% Constraints
% Battery temperature limits
min_batt_T = 25; 
max_batt_T = 35; 

% Power compressor limit
MaxEPowerCompressor = 6000; % W
% Rate of change of compressor power ( to avoid unrealistic changes of compressor power)
Pcomp_RateMin = -1000*Ts_MPC; % minimum W/step that can change the compressor power 
Pcomp_RateMax = +1000*Ts_MPC; % maximum W/step that can change the compressor power 